(function () {
  if (window.__airaRunning) return;
  window.__airaRunning = true;

  var remove_flag = true;
  var mainLoopId = null;
  var imageIntervalId = null;
  const SHOW_TIMER_BADGE = false;

  var EXT_BASE = (function () {
    try {
      if (typeof chrome === "object" && chrome?.runtime?.getURL) return chrome.runtime.getURL("");
    } catch (_) {}
    return null;
  })();

  var ITEM_RE = /^https:\/\/throne\.com\/aira_real\/item\/[^?#]+/i;
  var CHECKOUT_RE = /^https:\/\/throne\.com\/aira_real\/checkout\/[^?#]+/i;
  var PROFILE_URL = "https://throne.com/aira_real";
  var SLOT_RUN_KEY = "__aira_slot_run_ts";

  var __checkoutTimer = {
    started: false,
    startTs: 0,
    tickId: null,
    badgeEl: null,
    payNowPollId: null
  };

  function isExactProfileHref(href) {
    return href === PROFILE_URL;
  }

  function safeText(el) {
    return (el && (el.textContent || el.innerText) || "").trim();
  }

  function mmss(ms) {
    var total = Math.floor(ms / 1000);
    var m = Math.floor(total / 60);
    var s = total % 60;
    return String(m) + ":" + (s < 10 ? "0" + s : s);
  }

  function onceSlotStyle() {
    if (document.getElementById("__aira_slot_style")) return;
    var s = document.createElement("style");
    s.id = "__aira_slot_style";
    s.textContent =
      "\n#__aira_slot_overlay{position:fixed;inset:0;background:rgba(0,0,0,.75);display:flex;align-items:center;justify-content:center;z-index:2147483647}" +
      "\n#__aira_slot_panel{background:#0b0013;border:2px solid rgb(255,117,237);border-radius:16px;padding:24px 28px;min-width:320px;box-shadow:0 0 20px rgb(255,117,237),0 0 40px rgba(255,117,237,.4);text-align:center;color:#fff;font-family:system-ui,sans-serif}" +
      "\n#__aira_slot_title{font-size:20px;margin-bottom:12px}" +
      "\n#__aira_slot_reel{font-size:42px;font-weight:900;letter-spacing:2px;margin:10px 0 6px 0}" +
      "\n#__aira_slot_hint{font-size:12px;opacity:.85}";
    (document.head || document.documentElement).appendChild(s);
  }

  function pickWeightedTier() {
    var r = Math.random() * 100;
    if (r < 55) return 1;
    if (r < 85) return 2;
    return 3;
  }

  function requestSpinAudio() {
    try { chrome.runtime.sendMessage({ type: "aira_play_audio" }); } catch (_) {}
  }

  function runSlotMachine() {
    if (window.__airaSlotRunning) return true;
    window.__airaSlotRunning = true;
    onceSlotStyle();

    var overlay = document.createElement("div");
    overlay.id = "__aira_slot_overlay";

    var panel = document.createElement("div");
    panel.id = "__aira_slot_panel";

    var title = document.createElement("div");
    title.id = "__aira_slot_title";
    title.textContent = "Aira Slot";

    var reel = document.createElement("div");
    reel.id = "__aira_slot_reel";
    reel.textContent = "Tier ?";

    var hint = document.createElement("div");
    hint.id = "__aira_slot_hint";
    hint.textContent = "Spinning… destiny chooses your tribute.";

    panel.appendChild(title);
    panel.appendChild(reel);
    panel.appendChild(hint);
    overlay.appendChild(panel);
    document.documentElement.appendChild(overlay);

    var spinTimer = null;
    var displayTimer = null;

    function startSpin() {
      requestSpinAudio();
      var tiers = [2, 3, 4];
      var t = 0;
      spinTimer = setInterval(function () {
        reel.textContent = "Tier " + tiers[t % tiers.length];
        t++;
      }, 90);
      setTimeout(function () {
        clearInterval(spinTimer);
        var result = pickWeightedTier();
        reel.textContent = "Tier " + (result + 1);
        hint.textContent = "Routing to your tier…";
        var links = {
          1: "https://throne.com/aira_real/item/b9b68151-afc7-45e0-92ab-2597b5a7d72e",
          2: "https://throne.com/aira_real/item/e060305e-5261-423a-a2d7-cac8d2fb5983",
          3: "https://throne.com/aira_real/item/03e9cc39-71d4-4a4a-b052-ad86f67377b6"
        };
        displayTimer = setTimeout(function () {
          try { overlay.remove(); } catch (_) {}
          window.location.assign(links[result]);
        }, 800);
      }, 2500);
    }

    setTimeout(startSpin, 120);

    window.addEventListener(
      "pagehide",
      function () {
        try {
          clearInterval(spinTimer);
          clearTimeout(displayTimer);
        } catch (_) {}
        try {
          overlay.remove();
        } catch (_) {}
        window.__airaSlotRunning = false;
      },
      { once: true }
    );

    return true;
  }

  function tryRunSlotOnExactProfile() {
    if (!isExactProfileHref(location.href)) return false;
    var last = Number(sessionStorage.getItem(SLOT_RUN_KEY) || "0");
    var now = Date.now();
    if (now - last < 3000) return true;
    sessionStorage.setItem(SLOT_RUN_KEY, String(now));
    return runSlotMachine();
  }

  if (isExactProfileHref(location.href)) {
    tryRunSlotOnExactProfile();
  }

  function onceStyle() {
    if (document.getElementById("__aira_style")) return;
    const style = document.createElement("style");
    style.id = "__aira_style";
    style.textContent =
      "\n.popup-image{border-color:rgb(255,117,237);box-shadow:0 0 10px rgb(255,117,237),0 0 20px rgb(255,117,237),0 0 30px rgb(255,117,237);max-width:450px;min-width:150px;height:auto}" +
      "\n.popup-image:hover{border-color:rgb(163,15,163);box-shadow:0 0 10px rgb(163,15,163),0 0 20px rgb(163,15,163),0 0 30px rgb(163,15,163)}" +
      "\n#__aira_timer_badge{position:fixed;top:10px;right:12px;z-index:2147483646;background:#13001a;color:#fff;border:1px solid rgb(255,117,237);border-radius:10px;padding:6px 10px;font:600 12px/1.2 system-ui, sans-serif;box-shadow:0 0 10px rgba(255,117,237,.6)}";
    (document.head || document.documentElement).appendChild(style);
  }

  const imagePaths = Array.from({ length: 10 }, (_, i) => "images/" + (i + 1) + ".png");

  function spawnImage() {
    try {
      if (!EXT_BASE) return;
      const path = imagePaths[Math.floor(Math.random() * imagePaths.length)];
      const fullPath = EXT_BASE + path;
      const imgLoader = new Image();
      imgLoader.onload = function () {
        const scale = 0.5;
        const img = document.createElement("img");
        img.classList.add("popup-image");
        img.src = fullPath;
        img.style.position = "fixed";
        img.style.marginTop = "60px";
        img.style.left =
          Math.max(0, Math.random() * (window.innerWidth - imgLoader.naturalWidth * scale)) + "px";
        img.style.top =
          Math.max(0, Math.random() * (window.innerHeight - imgLoader.naturalHeight * scale)) + "px";
        img.style.width = "auto";
        img.style.height = "auto";
        img.style.zIndex = "10000";
        img.style.pointerEvents = "auto";
        img.style.borderWidth = "2px";
        img.style.borderStyle = "solid";
        img.style.borderRadius = "15px";
        document.body.appendChild(img);
        setTimeout(function () {
          try { img.remove(); } catch (_) {}
        }, 10000);
      };
      imgLoader.src = fullPath;
    } catch (_) {}
  }

  function clickAddToCartForCoffee() {
    setTimeout(function () {
      const productCards = document.querySelectorAll("[class*=chakra-stack]");
      for (const card of productCards) {
          const addButton = card.querySelector("button");
          if (addButton && addButton.textContent.toLowerCase().includes("remove from cart") && remove_flag) {
            remove_flag = false;
            addButton.click();
          }
          if (addButton && addButton.textContent.toLowerCase().includes("add")) {
            addButton.click();
            remove_flag = false;
            return;
          }
      }
    }, 6000);
  }

  function __findCheckoutButton() {
    const btns = document.querySelectorAll("button");
    for (const b of btns) {
      if (safeText(b).toLowerCase() === "checkout") return b;
    }
    return null;
  }

  function clickCheckoutIfExists() {
    setTimeout(function () {
      const btn = __findCheckoutButton();
      if (btn) {
        btn.click();
        startCheckoutTimer();
      }
    }, 6000);
  }

  function startPayNowPolling() {
    if (__checkoutTimer.payNowPollId) return;
    let attempts = 0;
    __checkoutTimer.payNowPollId = setInterval(function () {
      try {
        const buttons = document.querySelectorAll("button");
        for (const btn of buttons) {
          const span = btn.querySelector("span");
          const label = (span ? safeText(span) : safeText(btn)).toLowerCase();
          if (label === "pay now" && !btn.disabled) {
            btn.click();
            stopPayNowPolling();
            return;
          }
        }
      } catch (_) {}
      attempts += 1;
      if (attempts >= 50) {
        stopPayNowPolling();
      }
    }, 7000);
  }

  function stopPayNowPolling() {
    if (__checkoutTimer.payNowPollId) {
      clearInterval(__checkoutTimer.payNowPollId);
      __checkoutTimer.payNowPollId = null;
    }
  }

  function ensureTimerBadge() {
    if (!SHOW_TIMER_BADGE) return null;
    if (__checkoutTimer.badgeEl) return __checkoutTimer.badgeEl;
    const el = document.createElement("div");
    el.id = "__aira_timer_badge";
    el.textContent = "Timer: 0:00";
    document.documentElement.appendChild(el);
    __checkoutTimer.badgeEl = el;
    return el;
  }

  function startCheckoutTimer() {
    if (__checkoutTimer.started) return;
    __checkoutTimer.started = true;
    __checkoutTimer.startTs = Date.now();
    ensureTimerBadge();
    updateTimerBadge();
    __checkoutTimer.tickId = setInterval(updateTimerBadge, 1000);
    startPayNowPolling();
  }

  function updateTimerBadge() {
    if (!__checkoutTimer.started || !__checkoutTimer.badgeEl) return;
    var elapsed = Date.now() - __checkoutTimer.startTs;
    __checkoutTimer.badgeEl.textContent = "Timer: " + mmss(elapsed);
  }

  function stopCheckoutTimer() {
    if (__checkoutTimer.tickId) {
      clearInterval(__checkoutTimer.tickId);
      __checkoutTimer.tickId = null;
    }
    stopPayNowPolling();
    if (__checkoutTimer.badgeEl) {
      try { __checkoutTimer.badgeEl.remove(); } catch (_) {}
      __checkoutTimer.badgeEl = null;
    }
    __checkoutTimer.started = false;
    __checkoutTimer.startTs = 0;
  }

  function observeCheckoutClicks() {
    document.addEventListener("click", function (ev) {
      try {
        var btn = ev.target && (ev.target.closest ? ev.target.closest("button") : null);
        if (!btn) return;
        var label = safeText(btn).toLowerCase();
        if (label === "checkout") {
          startCheckoutTimer();
        }
      } catch (_) {}
    }, true);
  }

  function onURL(url) {
    if (!ITEM_RE.test(url) && !CHECKOUT_RE.test(url)) return;
    if (ITEM_RE.test(url)) {
      clickAddToCartForCoffee();
      clickCheckoutIfExists();
    }
  }

  function startLoops() {
    if (mainLoopId) return;
    const loop = function () {
      try { onURL(location.href); } catch (_) {}
      mainLoopId = setTimeout(loop, 1000);
    };
    loop();
    if (!imageIntervalId) imageIntervalId = setInterval(spawnImage, 500);
  }

  function stopLoops() {
    if (mainLoopId) { clearTimeout(mainLoopId); mainLoopId = null; }
    if (imageIntervalId) { clearInterval(imageIntervalId); imageIntervalId = null; }
  }

  function observeSPA() {
    let last = location.href;
    const fire = function () {
      const now = location.href;
      if (now !== last) {
        last = now;
        onURL(now);
      }
    };
    const origPush = history.pushState;
    const origReplace = history.replaceState;
    history.pushState = function () {
      origPush.apply(this, arguments);
      fire();
    };
    history.replaceState = function () {
      origReplace.apply(this, arguments);
      fire();
    };
    window.addEventListener("popstate", fire);
  }

  function cleanup() {
    stopLoops();
    stopCheckoutTimer();
    window.__airaRunning = false;
  }

  window.addEventListener(
    "error",
    function (e) {
      try {
        var msg = (e && (e.message || (e.error && String(e.error)))) || "";
        if (msg && msg.indexOf("Extension context invalidated") !== -1) {
          e.preventDefault();
          e.stopImmediatePropagation();
          return false;
        }
      } catch (_) {}
    },
    true
  );

  onceStyle();
  observeSPA();
  observeCheckoutClicks();
  startLoops();

  window.addEventListener("pagehide", cleanup, { once: true });
  window.addEventListener("beforeunload", cleanup, { once: true });

  document.addEventListener("visibilitychange", function () {
    if (document.visibilityState === "hidden") stopLoops();
    else startLoops();
  });
})();
