let audioA = null;
let audioB = null;
let lastIndex = -1;
let pairTimer = null;
const FILES = ["audios/1.mp3","audios/2.mp3","audios/3.mp3","audios/4.mp3","audios/5.mp3","audios/6.mp3","audios/7.mp3"];
const AUDIO_REPEAT = 6000

function ensureAudio(el) {
  if (!el) {
    el = new Audio();
    el.preload = "auto";
    el.volume = 1;
  }
  return el;
}

function pickNext(prev) {
  if (FILES.length <= 1) return 0;
  let i;
  do { i = Math.floor(Math.random() * FILES.length); } while (i === prev);
  return i;
}

function playWith(el, idx) {
  el.src = chrome.runtime.getURL(FILES[idx]);
  const p = el.play();
  if (p && p.catch) p.catch(() => {});
}

function playPair() {
  audioA = ensureAudio(audioA);
  audioB = ensureAudio(audioB);
  const first = pickNext(lastIndex);
  playWith(audioA, first);
  lastIndex = first;
  if (pairTimer) clearTimeout(pairTimer);
  pairTimer = setTimeout(() => {
    const second = pickNext(lastIndex);
    playWith(audioB, second);
    lastIndex = second;
  }, AUDIO_REPEAT);
}

chrome.runtime.onMessage.addListener((msg) => {
  if (msg && msg.type === "aira_offscreen_play") playPair();
});
